Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long


Public Const WH_CALLWNDPROC = 4
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6


Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Private Const WHEEL_DELTA = 120


Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type CWPSTRUCT
        lParam As Long
        wParam As Long
        message As Long
        hwnd As Long
End Type

Public Type MOUSEHOOKSTRUCT
        pt As POINTAPI
        hwnd As Long
        wHitTestCode As Long
        dwExtraInfo As Long
End Type

'This structure replaces MOUSEHOOKSTRUCT and is only valid in Windows 2000 and above
'  - The HIWORD of the MouseData member defines either
'      - The Mouse Wheel Delta or
'      - Which XButton was pressed or released (XBUTTON1 or XBUTTON2)
Public Type MOUSEHOOKSTRUCTEX
    structMouseHook As MOUSEHOOKSTRUCT
    MouseData As Long
End Type


Private lpPrevWndProc As Long
Private lpPrevDBGWndProc As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean


'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetMouseHook()
    If IsHooked Then
        MsgBox "Don't hook the MOUSE twice, or you will be unable to unhook it."
    Else
        lpPrevWndProc = SetWindowsHookEx(WH_MOUSE, AddressOf MouseProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub

Public Sub RemoveMouseHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevWndProc)
    IsHooked = False
End Sub


Public Function MouseProc(ByVal uCode As Long, ByVal wParam As Long, lParam As MOUSEHOOKSTRUCT) As Long
    If uCode < 0 Then
        MouseProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    Else
        Select Case uCode
            Case HC_ACTION
                Form2.Text1.Text = Form2.Text1.Text & "HC_ACTION    MSG:" & wParam & "    HWND:" & lParam.hwnd & "    HIT_TEST_CODE:" & lParam.wHitTestCode & "    EXTRA_INFO:" & lParam.dwExtraInfo & "    PT:" & CStr(lParam.pt.y) & vbNewLine
            Case HC_NOREMOVE
                Form2.Text1.Text = Form2.Text1.Text & "HC_NOREMOVE    MSG:" & wParam & "    HWND:" & lParam.hwnd & "    HIT_TEST_CODE:" & lParam.wHitTestCode & "    EXTRA_INFO:" & lParam.dwExtraInfo & "    PT:" & CStr(lParam.pt.y) & vbNewLine
            Case Else
        End Select
        
            
        MouseProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    End If
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't install the DEBUG hook twice, or you will be unable to unhook it."
    Else
        lpPrevDBGWndProc = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevDBGWndProc)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    If uCode < 0 Then
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    Else
        Select Case wParam
            Case WH_MOUSE
                Form2.Text1.Text = Form2.Text1.Text & "WH_MOUSE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & Hex(lParam.lParam) & vbNewLine
        End Select
            
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    End If
End Function

